/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.entity.forge;

import com.chefmooon.ubesdelight.common.block.entity.UniversalLeafFeastBlockEntity;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.forge.UbesDelightBlockEntityTypesImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;

public class UniversalLeafFeastBlockEntityImpl
extends SyncedBlockEntity {
    public static final int MAX_ITEMS = 6;
    private final ItemStackHandler inventory = this.createHandler();

    public UniversalLeafFeastBlockEntityImpl(BlockPos pos, BlockState state) {
        super(UbesDelightBlockEntityTypesImpl.UNIVERSAL_LEAF_FEAST.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public void clearInventory() {
        for (int i = 0; i < 6; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void setInventory(NonNullList<ItemStack> list) {
        for (int i = 0; i < 5; ++i) {
            this.inventory.setStackInSlot(i, (ItemStack)list.get(i));
        }
    }

    public int getContainerSize() {
        return 6;
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
        for (int i = 0; i < 6; ++i) {
            items.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return items;
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public boolean isFull() {
        return !this.inventory.getStackInSlot(5).m_41619_();
    }

    public boolean addItem(Player player, ItemStack itemStack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack inventoryStack = this.inventory.getStackInSlot(i);
            if (!inventoryStack.m_41619_()) continue;
            this.inventory.setStackInSlot(i, itemStack.m_41620_(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        for (int i = 5; i >= 0; --i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            this.inventoryChanged();
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public int getItemsQuantity() {
        int items = 0;
        for (int i = 0; i <= 5; ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            ++items;
        }
        return items;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public Vec2 getItemOffset(int index, LeafFeastTypes leafFeastType) {
        return UniversalLeafFeastBlockEntity.getItemOffset(index, leafFeastType);
    }

    public void m_7651_() {
        super.m_7651_();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                UniversalLeafFeastBlockEntityImpl.this.inventoryChanged();
            }
        };
    }
}

